ScriptName RaceMenuMorphsUUNP Extends RaceMenuBase

; Version data
Int Property NIOVERRIDE_VERSION = 6 AutoReadOnly
Int Property NIOVERRIDE_SCRIPT_VERSION = 6 AutoReadOnly
Int Property RM_UUNP_VERSION = 2 AutoReadOnly
Int Property Version = 0 Auto

String Property CALLBACK_FULLBODY = "ChangeFullbody" AutoReadOnly
String Property CALLBACK_PART = "ChangePart" AutoReadOnly

String Property CATEGORY_KEY = "rsm_bodymorph_uunp" AutoReadOnly
String Property MORPH_KEY = "RaceMenuMorphsUUNP.esp" AutoReadOnly

String[] fullBodyMorphs
String[] morphs

Event OnInit()
	Parent.OnInit()
	Version = RM_UUNP_VERSION
EndEvent

Bool Function CheckNiOverride()
	Return SKSE.GetPluginVersion("NiOverride") >= NIOVERRIDE_VERSION && NiOverride.GetScriptVersion() >= NIOVERRIDE_SCRIPT_VERSION
EndFunction

Function InitMorphNames()
	fullBodyMorphs = new String[38]
	fullBodyMorphs[0] = "7B"
	fullBodyMorphs[1] = "7B Bombshell"
	fullBodyMorphs[2] = "7B Natural"
	fullBodyMorphs[3] = "7B Cleavage"
	fullBodyMorphs[4] = "7B Bcup"
	fullBodyMorphs[5] = "7BUNP"
	fullBodyMorphs[6] = "7B CH"
	fullBodyMorphs[7] = "7B Oppai"
	fullBodyMorphs[8] = "UNP"
	fullBodyMorphs[9] = "UNP Pushup"
	fullBodyMorphs[10] = "UNP Skinny"
	fullBodyMorphs[11] = "UNP Perky"
	fullBodyMorphs[12] = "UNPB"		
	fullBodyMorphs[13] = "UNPB Chapi"
	fullBodyMorphs[14] = "UNPB Oppai v1"
	fullBodyMorphs[15] = "UNPB Oppai v3.2"
	fullBodyMorphs[16] = "UNPetite"
	fullBodyMorphs[17] = "UNPC"
	fullBodyMorphs[18] = "UNPCM"
	fullBodyMorphs[19] = "UNPSH"
	fullBodyMorphs[20] = "UNPK"
	fullBodyMorphs[21] = "UNPK Bonus"
	fullBodyMorphs[22] = "UN7B"
	fullBodyMorphs[23] = "UNPBB"
	fullBodyMorphs[24] = "Seraphim"
	fullBodyMorphs[25] = "Demonfet"
	fullBodyMorphs[26] = "Dream Girl"		
	fullBodyMorphs[27] = "Top Model"
	fullBodyMorphs[28] = "Leito"		
	fullBodyMorphs[29] = "UNPF"
	fullBodyMorphs[30] = "UNPFx"
	fullBodyMorphs[31] = "CNHF"
	fullBodyMorphs[32] = "CNHF Bonus"
	fullBodyMorphs[33] = "MCBM"
	fullBodyMorphs[34] = "Venus"
	fullBodyMorphs[35] = "ZGGB-R2"
	fullBodyMorphs[36] = "Manga"
	fullBodyMorphs[37] = "CHSBHC"
	
	morphs = new String[51]
	morphs[0] = "Breasts"
	morphs[1] = "BreastsSmall"
	morphs[2] = "BreastsSH"
	morphs[3] = "BreastsSSH"
	morphs[4] = "BreastsFantasy"
	morphs[5] = "DoubleMelon"
	morphs[6] = "BreastCleavage"
	morphs[7] = "BreastFlatness"
	morphs[8] = "BreastGravity"
	morphs[9] = "PushUp"
	morphs[10] = "BreastHeight"
	morphs[11] = "BreastPerkiness"
	morphs[12] = "BreastWidth"		
	morphs[13] = "NippleDistance"
	morphs[14] = "NipplePerkiness"
	morphs[15] = "NippleLength"
	morphs[16] = "NippleSize"
	morphs[17] = "NippleAreola"
	morphs[18] = "NippleUp"
	morphs[19] = "NippleDown"
	morphs[20] = "NippleTip"
	morphs[21] = "BigTorso"
	morphs[22] = "Waist"
	morphs[23] = "WideWaistLine"
	morphs[24] = "ChubbyWaist"
	morphs[25] = "Back"
	morphs[26] = "ButtCrack"		
	morphs[27] = "Butt"
	morphs[28] = "ButtSmall"		
	morphs[29] = "ButtShape2"
	morphs[30] = "BigButt"
	morphs[31] = "ChubbyButt"
	morphs[32] = "AppleCheeks"
	morphs[33] = "RoundAss"
	morphs[34] = "Hipbone"
	morphs[35] = "Hips"
	morphs[36] = "SlimThighs"
	morphs[37] = "Thighs"
	morphs[38] = "ChubbyLegs"
	morphs[39] = "Legs"
	morphs[40] = "KneeHeight"
	morphs[41] = "CalfSize"
	morphs[42] = "CalfSmooth"
	morphs[43] = "Arms"
	morphs[44] = "ChubbyArms"
	morphs[45] = "ShoulderSmooth"
	morphs[46] = "ShoulderWidth"
	morphs[47] = "Belly"
	morphs[48] = "BigBelly"
	morphs[49] = "PregnancyBelly"
	morphs[50] = "TummyTuck"
EndFunction


Event OnCategoryRequest()
	AddCategory(CATEGORY_KEY, "UUNP MORPHS", -947)
	InitMorphNames()
EndEvent

;Add custom sliders here
Event OnSliderRequest(Actor player, ActorBase playerBase, Race actorRace, Bool isFemale)
	If isFemale && CheckNiOverride()
		; Full Body
		Float factor = 1.0
		Int m
		While m < fullBodyMorphs.Length
			; Version Update
			If Version <= 0
				Float oldLow = NiOverride.GetMorphValue(_targetActor, fullBodyMorphs[m] + " Low")
				If oldLow > 0.0
					NiOverride.SetBodyMorph(_targetActor, fullBodyMorphs[m] + " Low", MORPH_KEY, -oldLow)
				EndIf
				Float oldHigh = NiOverride.GetMorphValue(_targetActor, fullBodyMorphs[m] + " High")
				If oldHigh > 0.0
					NiOverride.SetBodyMorph(_targetActor, fullBodyMorphs[m] + " High", MORPH_KEY, oldHigh)
				EndIf
				NiOverride.ClearMorphValue(_targetActor, fullBodyMorphs[m])
				NiOverride.ClearMorphValue(_targetActor, fullBodyMorphs[m] + " Low")
				NiOverride.ClearMorphValue(_targetActor, fullBodyMorphs[m] + " High")
			EndIf
			
			; Sliders
			If fullBodyMorphs[m] == "UNPB Chapi" || fullBodyMorphs[m] == "UNPB Oppai v1"
				AddSliderEx(fullBodyMorphs[m], CATEGORY_KEY, CALLBACK_FULLBODY + fullBodyMorphs[m], -factor, factor, 0.01, getBodyMorph(_targetActor, fullBodyMorphs[m]))
			Else
				AddSliderEx(fullBodyMorphs[m], CATEGORY_KEY, CALLBACK_FULLBODY + fullBodyMorphs[m], -factor, factor, 0.01, getBodyMorph(_targetActor, fullBodyMorphs[m], True))
			EndIf
			m += 1
		EndWhile
		
		; Part
		factor = 2.0
		m = 0
		While m < morphs.Length
			; Version Update
			If Version <= 0
				Float oldValue = NiOverride.GetMorphValue(_targetActor, morphs[m])
				If oldValue != 0.0
					NiOverride.SetBodyMorph(_targetActor, morphs[m], MORPH_KEY, oldValue)
				EndIf
				NiOverride.ClearMorphValue(_targetActor, morphs[m])
			EndIf
			
			; Sliders
			AddSliderEx(morphs[m], CATEGORY_KEY, CALLBACK_PART + morphs[m], -factor, factor, 0.01, getBodyMorph(_targetActor, morphs[m]))
			m += 1
		EndWhile
		
		Version = RM_UUNP_VERSION
	EndIf
EndEvent

Event OnSliderChanged(String callback, Float value)
	If CheckNiOverride()
		; Full Body
		Int m
		While m < fullBodyMorphs.Length
			If callback == CALLBACK_FULLBODY + fullBodyMorphs[m]
				If fullBodyMorphs[m] == "UNPB Chapi" || fullBodyMorphs[m] == "UNPB Oppai v1"
					addFullBodyMorph(_targetActor, fullBodyMorphs[m], value, False)
				Else
					addFullBodyMorph(_targetActor, fullBodyMorphs[m], value)
				EndIf
			EndIf
			m += 1
		EndWhile
		
		; Part
		m = 0
		While m < morphs.Length
			If callback == CALLBACK_PART + morphs[m]
				addBodyMorph(_targetActor, morphs[m], value)
			EndIf
			m += 1
		EndWhile
	EndIf
EndEvent

Function addFullBodyMorph(ObjectReference ref, String baseMorphName, Float value, Bool weightSlider = True)
	If weightSlider
		If value > 0
			NiOverride.SetBodyMorph(ref, baseMorphName + " High", MORPH_KEY, Math.abs(value))
			NiOverride.ClearBodyMorph(ref, baseMorphName + " Low", MORPH_KEY)
		ElseIf value < 0
			NiOverride.SetBodyMorph(ref, baseMorphName + " Low", MORPH_KEY, Math.abs(value))
			NiOverride.ClearBodyMorph(ref, baseMorphName + " High", MORPH_KEY)
		Else 
			NiOverride.ClearBodyMorph(ref, baseMorphName + " High", MORPH_KEY)
			NiOverride.ClearBodyMorph(ref, baseMorphName + " Low", MORPH_KEY)
		EndIf
	Else
		If value > 0
			NiOverride.SetBodyMorph(ref, baseMorphName, MORPH_KEY, Math.abs(value))
		Else 
			NiOverride.ClearBodyMorph(ref, baseMorphName, MORPH_KEY)
		EndIf
	EndIf
	NiOverride.UpdateModelWeight(ref)
EndFunction

Function addBodyMorph(ObjectReference ref, String baseMorphName, Float value)
	NiOverride.SetBodyMorph(ref, baseMorphName, MORPH_KEY, value)
	NiOverride.UpdateModelWeight(ref)
EndFunction

Float Function getFullBodyMorph(ObjectReference ref, String baseMorphName)
	Float low = NiOverride.GetBodyMorph(ref, baseMorphName + " Low", MORPH_KEY)
	If low > 0.0
		Return -low
	EndIf
	Float high = NiOverride.GetBodyMorph(ref, baseMorphName + " High", MORPH_KEY)
	If high > 0.0
		Return high
	EndIf
	Return 0.0
EndFunction


Float Function getBodyMorph(ObjectReference ref, String baseMorphName, Bool fullBody = False)
	If fullBody
		Return getFullBodyMorph(ref, baseMorphName)
	Else
		Return NiOverride.GetBodyMorph(ref, baseMorphName, MORPH_KEY)
	EndIf
EndFunction
